/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.base.Function;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.Helpers;

@OnlyIn(value=Dist.CLIENT)
public class RenderHelpers {
    private static final Random rand = new Random();
    public static final int SLOT_SIZE = 16;
    public static final Function<ResourceLocation, TextureAtlasSprite> TEXTURE_GETTER = location -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(location);

    public static void bindTexture(ResourceLocation texture) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
    }

    public static void emitParticle(Particle particle) {
        Minecraft.m_91087_().f_91061_.m_107344_(particle);
    }

    public static void drawScaledString(PoseStack matrixStack, Font fontRenderer, String string, int x, int y, float scale, int color) {
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, 0.0);
        matrixStack.m_85841_(scale, scale, 1.0f);
        fontRenderer.m_92883_(matrixStack, string, 0.0f, 0.0f, color);
        matrixStack.m_85849_();
    }

    public static void drawScaledStringWithShadow(PoseStack matrixStack, Font fontRenderer, String string, int x, int y, float scale, int color) {
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, 0.0);
        matrixStack.m_85841_(scale, scale, 1.0f);
        fontRenderer.m_92750_(matrixStack, string, 0.0f, 0.0f, color);
        matrixStack.m_85849_();
    }

    public static void drawScaledCenteredString(PoseStack matrixStack, Font fontRenderer, String string, int x, int y, int maxWidth, int color) {
        RenderHelpers.drawScaledCenteredString(matrixStack, fontRenderer, string, x, y, maxWidth, 1.0f, maxWidth, color);
    }

    public static void drawScaledCenteredString(PoseStack matrixStack, Font fontRenderer, String string, int x, int y, int width, float originalScale, int maxWidth, int color) {
        float originalWidth = (float)fontRenderer.m_92895_(string) * originalScale;
        float scale = Math.min(originalScale, (float)maxWidth / originalWidth * originalScale);
        RenderHelpers.drawScaledCenteredString(matrixStack, fontRenderer, string, x, y, width, scale, color);
    }

    public static void drawScaledCenteredString(PoseStack matrixStack, Font fontRenderer, String string, int x, int y, int width, float scale, int color) {
        matrixStack.m_85836_();
        matrixStack.m_85841_(scale, scale, 1.0f);
        int titleLength = fontRenderer.m_92895_(string);
        Objects.requireNonNull(fontRenderer);
        int titleHeight = 9;
        fontRenderer.m_92883_(matrixStack, string, (float)Math.round((float)(x + width / 2) / scale - (float)(titleLength / 2)), (float)Math.round((float)y / scale - (float)(titleHeight / 2)), color);
        matrixStack.m_85849_();
    }

    public static BakedModel getBakedModel(BlockState blockState) {
        Minecraft mc = Minecraft.m_91087_();
        BlockRenderDispatcher blockRendererDispatcher = mc.m_91289_();
        BlockModelShaper blockModelShapes = blockRendererDispatcher.m_110907_();
        return blockModelShapes.m_110893_(blockState);
    }

    public static BakedModel getDynamicBakedModel(Level world, BlockPos pos) {
        return RenderHelpers.getBakedModel(world.m_8055_(pos));
    }

    public static void addBlockHitEffects(ParticleEngine particleManager, ClientLevel world, BlockState blockState, BlockPos pos, Direction side) {
        if (blockState.m_60799_() != RenderShape.INVISIBLE) {
            int i = pos.m_123341_();
            int j = pos.m_123342_();
            int k = pos.m_123343_();
            float f = 0.1f;
            AABB bb = blockState.m_60808_((BlockGetter)world, pos).m_83215_();
            double d0 = (double)i + rand.nextDouble() * (bb.f_82291_ - bb.f_82288_ - (double)(f * 2.0f)) + (double)f + bb.f_82288_;
            double d1 = (double)j + rand.nextDouble() * (bb.f_82292_ - bb.f_82289_ - (double)(f * 2.0f)) + (double)f + bb.f_82289_;
            double d2 = (double)k + rand.nextDouble() * (bb.f_82293_ - bb.f_82290_ - (double)(f * 2.0f)) + (double)f + bb.f_82290_;
            if (side == Direction.DOWN) {
                d1 = (double)j + bb.f_82289_ - (double)f;
            }
            if (side == Direction.UP) {
                d1 = (double)j + bb.f_82292_ + (double)f;
            }
            if (side == Direction.NORTH) {
                d2 = (double)k + bb.f_82290_ - (double)f;
            }
            if (side == Direction.SOUTH) {
                d2 = (double)k + bb.f_82293_ + (double)f;
            }
            if (side == Direction.WEST) {
                d0 = (double)i + bb.f_82288_ - (double)f;
            }
            if (side == Direction.EAST) {
                d0 = (double)i + bb.f_82291_ + (double)f;
            }
            Particle fx = new TerrainParticle.Provider().m_6966_(new BlockParticleOption(ParticleTypes.f_123794_, blockState), world, d0, d1, d2, 0.0, 0.0, 0.0);
            particleManager.m_107344_(fx);
        }
    }

    public static TextureAtlasSprite getBlockIcon(Block block) {
        return Minecraft.m_91087_().m_91289_().m_110907_().m_110882_(block.m_49966_());
    }

    public static TextureAtlasSprite getFluidIcon(Fluid fluid, Direction side) {
        return RenderHelpers.getFluidIcon(new FluidStack(fluid, 1000), side);
    }

    public static TextureAtlasSprite getFluidIcon(FluidStack fluid, Direction side) {
        TextureAtlasSprite icon;
        if (side == null) {
            side = Direction.UP;
        }
        if ((icon = (TextureAtlasSprite)TEXTURE_GETTER.apply((Object)fluid.getFluid().getAttributes().getFlowingTexture(fluid))) == null || side == Direction.UP || side == Direction.DOWN) {
            icon = (TextureAtlasSprite)TEXTURE_GETTER.apply((Object)fluid.getFluid().getAttributes().getStillTexture(fluid));
        }
        return icon;
    }

    public static void renderFluidContext(FluidStack fluid, PoseStack matrixStack, IFluidContextRender render) {
        if (fluid != null && fluid.getAmount() > 0) {
            matrixStack.m_85836_();
            RenderSystem.m_69478_();
            RenderSystem.m_69464_();
            RenderSystem.m_69478_();
            RenderSystem.m_69405_((int)770, (int)771);
            Minecraft.m_91087_().m_91097_().m_174784_(TextureAtlas.f_118259_);
            render.render();
            RenderSystem.m_69461_();
            matrixStack.m_85849_();
        }
    }

    public static Triple<Float, Float, Float> getFluidVertexBufferColor(FluidStack fluidStack) {
        int color = fluidStack.getFluid().getAttributes().getColor(fluidStack);
        return Helpers.intToRGB(color);
    }

    public static int getFluidBakedQuadColor(FluidStack fluidStack) {
        Triple<Float, Float, Float> colorParts = Helpers.intToRGB(fluidStack.getFluid().getAttributes().getColor(fluidStack));
        return Helpers.RGBAToInt((int)(((Float)colorParts.getRight()).floatValue() * 255.0f), (int)(((Float)colorParts.getMiddle()).floatValue() * 255.0f), (int)(((Float)colorParts.getLeft()).floatValue() * 255.0f), 255);
    }

    public static boolean isPointInRegion(int left, int top, int width, int height, double pointX, double pointY) {
        return pointX >= (double)left && pointX < (double)(left + width) && pointY >= (double)top && pointY < (double)(top + height);
    }

    public static boolean isPointInRegion(Rectangle region, Point point) {
        return RenderHelpers.isPointInRegion(region.x, region.y, region.width, region.height, point.x, point.y);
    }

    public static boolean isPointInButton(Button button, int pointX, int pointY) {
        return RenderHelpers.isPointInRegion(button.f_93620_, button.f_93621_, button.m_5711_(), button.m_93694_(), pointX, pointY);
    }

    public static void blitColored(PoseStack poseStack, int x, int y, int z, float u, float v, int width, int height, float r, float g, float b, float a) {
        RenderHelpers.blitColored(poseStack, x, y, z, width, height, u / 256.0f, (u + (float)width) / 256.0f, v / 256.0f, (v + (float)height) / 256.0f, r, g, b, a);
    }

    public static void blitColored(PoseStack poseStack, int x, int y, int z, int width, int height, float u0, float u1, float v0, float v1, float r, float g, float b, float a) {
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(matrix4f, (float)x, (float)y + (float)height, (float)z).m_7421_(u0, v1).m_5752_();
        bufferbuilder.m_85982_(matrix4f, (float)x + (float)width, (float)y + (float)height, (float)z).m_7421_(u1, v1).m_5752_();
        bufferbuilder.m_85982_(matrix4f, (float)x + (float)width, (float)y, (float)z).m_7421_(u1, v0).m_5752_();
        bufferbuilder.m_85982_(matrix4f, (float)x, (float)y, (float)z).m_7421_(u0, v0).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static interface IFluidContextRender {
        public void render();
    }
}

